/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.config.base;

import com.izforge.izpack.util.config.base.BasicOptionMap;
import com.izforge.izpack.util.config.base.Config;
import com.izforge.izpack.util.config.base.Configurable;
import com.izforge.izpack.util.config.base.InvalidFileFormatException;
import com.izforge.izpack.util.config.base.Persistable;
import com.izforge.izpack.util.config.base.spi.OptionsBuilder;
import com.izforge.izpack.util.config.base.spi.OptionsFormatter;
import com.izforge.izpack.util.config.base.spi.OptionsHandler;
import com.izforge.izpack.util.config.base.spi.OptionsParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;

public class Options
extends BasicOptionMap
implements Persistable,
Configurable {
    private static final long serialVersionUID = -1119753444859181822L;
    private String _comment;
    private Config _config;
    private File _file;

    public Options() {
        this(Config.getGlobal().clone());
    }

    public Options(Config config) {
        config.setEmptyOption(true);
        this.setConfig(config);
    }

    public Options(Reader input) throws IOException, InvalidFileFormatException {
        this();
        this.load(input);
    }

    public Options(InputStream input) throws IOException, InvalidFileFormatException {
        this();
        this.load(input);
    }

    public Options(URL input) throws IOException, InvalidFileFormatException {
        this();
        this.load(input);
    }

    public Options(File input) throws IOException, InvalidFileFormatException {
        this();
        this._file = input;
        this.load();
    }

    public String getComment() {
        return this._comment;
    }

    public void setComment(String value) {
        this._comment = value;
    }

    @Override
    public Config getConfig() {
        return this._config;
    }

    @Override
    public void setConfig(Config value) {
        this._config = value;
    }

    @Override
    public File getFile() {
        return this._file;
    }

    @Override
    public void setFile(File value) {
        this._file = value;
    }

    @Override
    public void load() throws IOException, InvalidFileFormatException {
        if (this._file == null) {
            throw new FileNotFoundException();
        }
        this.load(this._file);
    }

    @Override
    public void load(InputStream input) throws IOException, InvalidFileFormatException {
        this.load(new InputStreamReader(input, this.getConfig().getFileEncoding()));
    }

    @Override
    public void load(Reader input) throws IOException, InvalidFileFormatException {
        OptionsParser.newInstance(this.getConfig()).parse(input, this.newBuilder());
    }

    @Override
    public void load(URL input) throws IOException, InvalidFileFormatException {
        OptionsParser.newInstance(this.getConfig()).parse(input, this.newBuilder());
    }

    @Override
    public void load(File input) throws IOException, InvalidFileFormatException {
        this.load(input.toURI().toURL());
    }

    @Override
    public void store() throws IOException {
        if (this._file == null) {
            throw new FileNotFoundException();
        }
        this.store(this._file);
    }

    @Override
    public void store(OutputStream output) throws IOException {
        this.store(new OutputStreamWriter(output, this.getConfig().getFileEncoding()));
    }

    @Override
    public void store(Writer output) throws IOException {
        this.store(OptionsFormatter.newInstance(output, this.getConfig()));
    }

    @Override
    public void store(File output) throws IOException {
        FileOutputStream stream = new FileOutputStream(output);
        this.store(stream);
        ((OutputStream)stream).close();
    }

    protected OptionsHandler newBuilder() {
        return OptionsBuilder.newInstance(this);
    }

    protected void store(OptionsHandler formatter) throws IOException {
        formatter.startOptions();
        this.storeComment(formatter, this._comment);
        for (String name : this.keySet()) {
            this.storeNewLines(formatter, this.getNewLineCount(name));
            this.storeComment(formatter, this.getComment(name));
            int n = this.getConfig().isMultiOption() || this.getConfig().isAutoNumbering() ? this.length(name) : 1;
            for (int i = 0; i < n; ++i) {
                String value = (String)this.get((Object)name, i);
                if (this.getConfig().isAutoNumbering() && name.endsWith(".")) {
                    if (value == null) continue;
                    formatter.handleOption(name + i, value);
                    continue;
                }
                formatter.handleOption(name, value);
            }
        }
        formatter.endOptions();
    }

    @Override
    boolean isPropertyFirstUpper() {
        return this.getConfig().isPropertyFirstUpper();
    }

    private void storeNewLines(OptionsHandler formatter, int emptyLines) {
        for (int i = 0; i < emptyLines; ++i) {
            formatter.handleEmptyLine();
        }
    }

    private void storeComment(OptionsHandler formatter, String comment) {
        formatter.handleComment(comment);
    }
}

