/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.target;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.installer.console.AbstractConsolePanel;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.panels.target.TargetPanelHelper;
import com.izforge.izpack.util.Console;
import java.io.File;
import java.io.PrintWriter;
import java.util.Properties;

public class TargetConsolePanel
extends AbstractConsolePanel
implements ConsolePanel {
    public TargetConsolePanel(PanelView<ConsolePanel> panel) {
        super(panel);
    }

    @Override
    public boolean generateProperties(InstallData installData, PrintWriter printWriter) {
        printWriter.println("INSTALL_PATH=");
        return true;
    }

    @Override
    public boolean run(InstallData installData, Properties properties) {
        boolean result = false;
        String path = properties.getProperty("INSTALL_PATH");
        if (path == null || "".equals(path.trim())) {
            System.err.println("Missing mandatory target path!");
        } else if (TargetPanelHelper.isIncompatibleInstallation(path)) {
            System.err.println(this.getIncompatibleInstallationMsg(installData));
        } else {
            path = installData.getVariables().replace(path);
            installData.setInstallPath(path);
            result = true;
        }
        return result;
    }

    @Override
    public boolean run(InstallData installData, Console console) {
        String path;
        String defaultPath = TargetPanelHelper.getPath(installData);
        if (defaultPath == null) {
            defaultPath = "";
        }
        if ((path = console.prompt("Select target path [" + defaultPath + "] ", null)) != null) {
            if ((path = path.trim()).isEmpty()) {
                path = defaultPath;
            }
            if (TargetPanelHelper.isIncompatibleInstallation(path = installData.getVariables().replace(path))) {
                console.println(this.getIncompatibleInstallationMsg(installData));
                return this.run(installData, console);
            }
            if (!path.isEmpty()) {
                File selectedDir = new File(path);
                if (selectedDir.exists() && selectedDir.isDirectory() && selectedDir.list().length > 0) {
                    console.println(installData.getMessages().get("TargetPanel.warn", new Object[0]));
                }
                installData.setInstallPath(path);
                return this.promptEndPanel(installData, console);
            }
            return this.run(installData, console);
        }
        return false;
    }

    private String getIncompatibleInstallationMsg(InstallData installData) {
        return installData.getMessages().get("TargetPanel.incompatibleInstallation", new Object[0]);
    }
}

