/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.shortcut;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.api.adaptator.impl.XMLParser;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.binding.OsModel;
import com.izforge.izpack.api.event.AbstractInstallerListener;
import com.izforge.izpack.api.event.ProgressListener;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.exception.ResourceNotFoundException;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.substitutor.SubstitutionType;
import com.izforge.izpack.core.substitutor.VariableSubstitutorImpl;
import com.izforge.izpack.data.ExecutableFile;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.installer.event.InstallerListeners;
import com.izforge.izpack.panels.shortcut.ShortcutData;
import com.izforge.izpack.util.CleanupClient;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.OsConstraintHelper;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.Platform;
import com.izforge.izpack.util.PlatformModelMatcher;
import com.izforge.izpack.util.StringTool;
import com.izforge.izpack.util.TargetFactory;
import com.izforge.izpack.util.file.FileUtils;
import com.izforge.izpack.util.os.Shortcut;
import com.izforge.izpack.util.os.Unix_Shortcut;
import com.izforge.izpack.util.unix.UnixHelper;
import com.izforge.izpack.util.xml.XMLHelper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ShortcutPanelLogic
implements CleanupClient {
    private static final transient Logger logger = Logger.getLogger(ShortcutPanelLogic.class.getName());
    public static final String SPEC_ATTRIBUTE_CONDITION = "condition";
    private static final String SPEC_ATTRIBUTE_KDE_USERNAME = "KdeUsername";
    private static final String SPEC_ATTRIBUTE_KDE_SUBST_UID = "KdeSubstUID";
    private static final String SPEC_ATTRIBUTE_URL = "url";
    private static final String SPEC_ATTRIBUTE_TYPE = "type";
    private static final String SPEC_ATTRIBUTE_TERMINAL_OPTIONS = "terminalOptions";
    private static final String SPEC_ATTRIBUTE_TERMINAL = "terminal";
    private static final String SPEC_ATTRIBUTE_MIMETYPE = "mimetype";
    private static final String SPEC_ATTRIBUTE_ENCODING = "encoding";
    private static final String SPEC_CATEGORIES = "categories";
    private static final String SPEC_TRYEXEC = "tryexec";
    private static final String SEPARATOR_LINE = "--------------------------------------------------------------------------------";
    private static final String SPEC_FILE_NAME = "shortcutSpec.xml";
    private static final String SPEC_KEY_SKIP_IFNOT_SUPPORTED = "skipIfNotSupported";
    private static final String SPEC_KEY_NOT_SUPPORTED = "notSupported";
    private static final String SPEC_KEY_DEF_CUR_USER = "defaultCurrentUser";
    private static final String SPEC_KEY_LATE_INSTALL = "lateShortcutInstall";
    private static final String SPEC_KEY_PROGRAM_GROUP = "programGroup";
    private static final String SPEC_KEY_SHORTCUT = "shortcut";
    private static final String SPEC_KEY_PACKS = "createForPack";
    private static final String SPEC_ATTRIBUTE_DEFAULT_GROUP = "defaultName";
    private static final String SPEC_ATTRIBUTE_INSTALLGROUP = "installGroup";
    private static final String SPEC_ATTRIBUTE_LOCATION = "location";
    private static final String SPEC_ATTRIBUTE_NAME = "name";
    private static final String SPEC_ATTRIBUTE_SUBGROUP = "subgroup";
    private static final String SPEC_ATTRIBUTE_DESCRIPTION = "description";
    private static final String SPEC_ATTRIBUTE_TARGET = "target";
    private static final String SPEC_ATTRIBUTE_COMMAND = "commandLine";
    private static final String SPEC_ATTRIBUTE_ICON = "iconFile";
    private static final String SPEC_ATTRIBUTE_ICON_INDEX = "iconIndex";
    private static final String SPEC_ATTRIBUTE_WORKING_DIR = "workingDirectory";
    private static final String SPEC_ATTRIBUTE_INITIAL_STATE = "initialState";
    private static final String SPEC_ATTRIBUTE_DESKTOP = "desktop";
    private static final String SPEC_ATTRIBUTE_APPLICATIONS = "applications";
    private static final String SPEC_ATTRIBUTE_START_MENU = "startMenu";
    private static final String SPEC_ATTRIBUTE_STARTUP = "startup";
    private static final String SPEC_ATTRIBUTE_PROGRAM_GROUP = "programGroup";
    private static final String SPEC_ATTRIBUTE_RUN_AS_ADMINISTRATOR = "runAsAdministrator";
    private static final String SPEC_VALUE_APPLICATIONS = "applications";
    private static final String SPEC_VALUE_START_MENU = "startMenu";
    private static final String SPEC_VALUE_NO_SHOW = "noShow";
    private static final String SPEC_VALUE_NORMAL = "normal";
    private static final String SPEC_VALUE_MAXIMIZED = "maximized";
    private static final String SPEC_VALUE_MINIMIZED = "minimized";
    private static final String AUTO_KEY_PROGRAM_GROUP = "programGroup";
    private static final String AUTO_KEY_SHORTCUT_TYPE = "shortcutType";
    private static final String AUTO_KEY_CREATE_DESKTOP_SHORTCUTS = "createDesktopShortcuts";
    private static final String AUTO_KEY_CREATE_SHORTCUTS = "createShortcuts";
    private static final String AUTO_KEY_SHORTCUT_TYPE_VALUE_ALL = "all";
    private static final String AUTO_KEY_SHORTCUT_TYPE_VALUE_USER = "user";
    private static final String CREATE_FOR_ALL = "createForAll";
    private String suggestedProgramGroup;
    private String groupName;
    private String programGroupIconFile;
    private String programGroupComment;
    private IXMLElement spec;
    private boolean hasDesktopShortcuts = false;
    private boolean skipIfNotSupported = false;
    private Shortcut shortcut;
    private List<ShortcutData> shortcuts;
    private List<String> files;
    private List<ExecutableFile> execFiles;
    private boolean createShortcuts = false;
    private boolean haveShortcutSpec = false;
    private boolean simulateNotSupported = false;
    private int userType;
    private final InstallData installData;
    private final Resources resources;
    private final UninstallData uninstallData;
    private final PlatformModelMatcher matcher;
    private boolean createDesktopShortcuts;
    private boolean defaultCurrentUserFlag = false;
    private boolean createShortcutsImmediately = true;

    public ShortcutPanelLogic(InstallData installData, Resources resources, UninstallData uninstallData, Housekeeper housekeeper, TargetFactory factory, InstallerListeners listeners, PlatformModelMatcher matcher) throws Exception {
        this.installData = installData;
        this.resources = resources;
        this.uninstallData = uninstallData;
        this.matcher = matcher;
        this.shortcut = factory.makeObject(Shortcut.class);
        this.shortcut.initialize(1, "-");
        this.readShortcutSpec();
        this.analyzeShortcutSpec();
        if (!this.isCreateShortcutsImmediately()) {
            listeners.add(new LateShortcutInstallListener());
        }
        housekeeper.registerForCleanup(this);
    }

    public final boolean isCreateShortcutsImmediately() {
        return this.createShortcutsImmediately;
    }

    public final void setCreateShortcutsImmediately(boolean createShortcutsImmediately) {
        this.createShortcutsImmediately = createShortcutsImmediately;
    }

    public void createAndRegisterShortcuts() throws Exception {
        String groupName = this.groupName;
        boolean createShortcuts = this.createShortcuts;
        boolean createDesktopShortcuts = this.createDesktopShortcuts;
        this.readShortcutSpec();
        this.analyzeShortcutSpec();
        this.groupName = groupName;
        this.createShortcuts = createShortcuts;
        this.createDesktopShortcuts = createDesktopShortcuts;
        this.createShortcuts();
        this.addToUninstaller();
    }

    public List<String> getProgramGroups(int user) {
        return this.shortcut.getProgramGroups(user);
    }

    public File getProgramsFolder(int user) {
        String path = this.shortcut.getProgramsFolder(user);
        return new File(path);
    }

    public String getSuggestedProgramGroup() {
        return this.installData.getVariables().replace(this.suggestedProgramGroup);
    }

    public void setSuggestedProgramGroup(String suggestedProgramGroup) {
        this.suggestedProgramGroup = suggestedProgramGroup;
    }

    public List<String> getTargets() {
        ArrayList<String> retVal = new ArrayList<String>();
        for (ShortcutData data : this.shortcuts) {
            retVal.add(data.target);
        }
        return retVal;
    }

    public int getUserType() {
        return this.userType;
    }

    public List<IXMLElement> getAutoinstallXMLData(IXMLElement panelRoot) {
        ArrayList<IXMLElement> xmlData = new ArrayList<IXMLElement>();
        XMLElementImpl dataElement = new XMLElementImpl(AUTO_KEY_CREATE_SHORTCUTS, panelRoot);
        dataElement.setContent(Boolean.toString(this.isCreateShortcuts()));
        xmlData.add(dataElement);
        if (this.isCreateShortcuts()) {
            dataElement = new XMLElementImpl("programGroup", panelRoot);
            dataElement.setContent(this.getGroupName());
            xmlData.add(dataElement);
            dataElement = new XMLElementImpl(AUTO_KEY_CREATE_DESKTOP_SHORTCUTS, panelRoot);
            dataElement.setContent(this.getGroupName());
            xmlData.add(dataElement);
            dataElement = new XMLElementImpl(AUTO_KEY_SHORTCUT_TYPE, panelRoot);
            String userTypeString = this.getUserType() == 1 ? AUTO_KEY_SHORTCUT_TYPE_VALUE_USER : AUTO_KEY_SHORTCUT_TYPE_VALUE_ALL;
            dataElement.setContent(userTypeString);
            xmlData.add(dataElement);
        }
        return xmlData;
    }

    public void setAutoinstallXMLData(IXMLElement panelRoot) {
        IXMLElement dataElement = panelRoot.getFirstChildNamed(AUTO_KEY_CREATE_SHORTCUTS);
        this.setCreateShortcuts(Boolean.valueOf(dataElement.getContent()));
        if (this.isCreateShortcuts()) {
            dataElement = panelRoot.getFirstChildNamed("programGroup");
            this.setGroupName(dataElement.getContent());
            dataElement = panelRoot.getFirstChildNamed(AUTO_KEY_CREATE_DESKTOP_SHORTCUTS);
            this.setCreateDesktopShortcuts(Boolean.valueOf(dataElement.getContent()));
            dataElement = panelRoot.getFirstChildNamed(AUTO_KEY_SHORTCUT_TYPE);
            if (AUTO_KEY_SHORTCUT_TYPE_VALUE_USER.equals(dataElement.getContent())) {
                this.setUserType(1);
            } else {
                this.setUserType(2);
            }
        }
    }

    public final boolean isDefaultCurrentUserFlag() {
        return this.defaultCurrentUserFlag;
    }

    public boolean hasDesktopShortcuts() {
        return this.hasDesktopShortcuts;
    }

    public boolean isCreateDesktopShortcuts() {
        return this.createDesktopShortcuts;
    }

    public void setCreateDesktopShortcuts(boolean createDesktopShortcuts) {
        this.createDesktopShortcuts = createDesktopShortcuts;
    }

    public boolean isCreateShortcuts() {
        return this.createShortcuts;
    }

    public final void setCreateShortcuts(boolean createShortcuts) {
        this.createShortcuts = createShortcuts;
    }

    public boolean isSimulateNotSupported() {
        return this.simulateNotSupported;
    }

    public boolean isSkipIfNotSupported() {
        return this.skipIfNotSupported;
    }

    public boolean isSupported() {
        return !this.simulateNotSupported && this.shortcut.supported();
    }

    public boolean isSupportingMultipleUsers() {
        return this.shortcut.multipleUsers();
    }

    @Override
    public void cleanUp() {
        if (!this.installData.isInstallSuccess()) {
            for (String file : this.files) {
                File fl = new File(file);
                if (!fl.exists()) continue;
                fl.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile(File file) {
        FileWriter output = null;
        StringBuilder buffer = new StringBuilder();
        Messages messages = this.installData.getMessages();
        String header = messages.get("ShortcutPanel.textFile.header", new Object[0]);
        String newline = System.getProperty("line.separator", "\n");
        try {
            output = new FileWriter(file);
        }
        catch (Throwable exception) {
            return;
        }
        int nextIndex = 0;
        int currentIndex = 0;
        do {
            if ((nextIndex = header.indexOf("\\n", currentIndex)) > -1) {
                buffer.append(header.substring(currentIndex, nextIndex));
                buffer.append(newline);
                currentIndex = nextIndex + 2;
                continue;
            }
            buffer.append(header.substring(currentIndex, header.length()));
            buffer.append(newline);
        } while (nextIndex > -1);
        buffer.append(SEPARATOR_LINE);
        buffer.append(newline);
        buffer.append(newline);
        for (ShortcutData data : this.shortcuts) {
            buffer.append(messages.get("ShortcutPanel.textFile.name", new Object[0]));
            buffer.append(data.name);
            buffer.append(newline);
            buffer.append(messages.get("ShortcutPanel.textFile.location", new Object[0]));
            switch (data.type) {
                case 3: {
                    buffer.append(messages.get("ShortcutPanel.location.desktop", new Object[0]));
                    break;
                }
                case 1: {
                    buffer.append(messages.get("ShortcutPanel.location.applications", new Object[0]));
                    break;
                }
                case 2: {
                    buffer.append(messages.get("ShortcutPanel.location.startMenu", new Object[0]));
                    break;
                }
                case 4: {
                    buffer.append(messages.get("ShortcutPanel.location.startup", new Object[0]));
                }
            }
            buffer.append(newline);
            buffer.append(messages.get("ShortcutPanel.textFile.description", new Object[0]));
            buffer.append(data.description);
            buffer.append(newline);
            buffer.append(messages.get("ShortcutPanel.textFile.target", new Object[0]));
            buffer.append(data.target);
            buffer.append(newline);
            buffer.append(messages.get("ShortcutPanel.textFile.command", new Object[0]));
            buffer.append(data.commandLine);
            buffer.append(newline);
            buffer.append(messages.get("ShortcutPanel.textFile.iconName", new Object[0]));
            buffer.append(data.iconFile);
            buffer.append(newline);
            buffer.append(messages.get("ShortcutPanel.textFile.iconIndex", new Object[0]));
            buffer.append(data.iconIndex);
            buffer.append(newline);
            buffer.append(messages.get("ShortcutPanel.textFile.work", new Object[0]));
            buffer.append(data.workingDirectory);
            buffer.append(newline);
            buffer.append(newline);
            buffer.append(SEPARATOR_LINE);
            buffer.append(newline);
            buffer.append(newline);
        }
        try {
            output.write(buffer.toString());
        }
        catch (Throwable exception) {
        }
        finally {
            try {
                output.flush();
                output.close();
                this.files.add(file.getPath());
            }
            catch (Throwable exception) {}
        }
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setUserType(int userType) {
        this.userType = userType;
        this.shortcut.setUserType(this.userType);
    }

    public boolean initUserType() {
        File dir = this.getProgramsFolder(2);
        logger.fine("All Users Program Folder: '" + dir + "'");
        boolean writable = this.isWritable(dir);
        logger.fine((writable ? "Can" : "Cannot") + " write into '" + dir + "'");
        boolean allUsers = !this.isDefaultCurrentUserFlag() && writable;
        int type = allUsers ? 2 : 1;
        this.setUserType(type);
        return writable;
    }

    public boolean isDesktopShortcutCheckboxSelected() {
        return Boolean.valueOf(this.installData.getVariable("DesktopShortcutCheckboxEnabled"));
    }

    public String getCreateShortcutsPrompt() {
        Messages messages = this.installData.getMessages();
        String menuKind = messages.get("ShortcutPanel.regular.StartMenu:Start-Menu", new Object[0]);
        if (this.installData.getPlatform().isA(Platform.Name.UNIX) && UnixHelper.kdeIsInstalled()) {
            menuKind = messages.get("ShortcutPanel.regular.StartMenu:K-Menu", new Object[0]);
        }
        return StringTool.replace(messages.get("ShortcutPanel.regular.create", new Object[0]), "StartMenu", menuKind);
    }

    public String getCreateDesktopShortcutsPrompt() {
        return this.installData.getMessages().get("ShortcutPanel.regular.desktop", new Object[0]);
    }

    public String getCreateForUserPrompt() {
        return this.installData.getMessages().get("ShortcutPanel.regular.userIntro", new Object[0]);
    }

    public String getCreateForAllUsersPrompt() {
        return this.installData.getMessages().get("ShortcutPanel.regular.allUsers", new Object[0]);
    }

    public String getCreateForCurrentUserPrompt() {
        return this.installData.getMessages().get("ShortcutPanel.regular.currentUser", new Object[0]);
    }

    private boolean isWritable(File dir) {
        boolean result = false;
        try {
            File test = File.createTempFile(SPEC_KEY_SHORTCUT, "", dir);
            FileUtils.delete(test);
            result = true;
        }
        catch (IOException exception) {
            logger.log(Level.WARNING, "Cannot write to '" + dir + "'", exception);
        }
        return result;
    }

    private void addToUninstaller() {
        for (String file : this.files) {
            this.uninstallData.addFile(file, true);
        }
    }

    private void analyzeShortcutSpec() {
        if (!this.haveShortcutSpec) {
            this.createShortcuts = false;
            return;
        }
        IXMLElement skipper = this.spec.getFirstChildNamed(SPEC_KEY_SKIP_IFNOT_SUPPORTED);
        this.skipIfNotSupported = skipper != null;
        this.defaultCurrentUserFlag = this.spec.getFirstChildNamed(SPEC_KEY_DEF_CUR_USER) != null;
        IXMLElement support = this.spec.getFirstChildNamed(SPEC_KEY_NOT_SUPPORTED);
        if (support != null) {
            this.simulateNotSupported = true;
        }
        this.setCreateShortcutsImmediately(this.spec.getFirstChildNamed(SPEC_KEY_LATE_INSTALL) == null);
        IXMLElement group = null;
        List<IXMLElement> groupSpecs = this.spec.getChildrenNamed("programGroup");
        String selectedInstallGroup = this.installData.getVariable("INSTALL_GROUP");
        if (selectedInstallGroup != null) {
            for (IXMLElement g : groupSpecs) {
                String instGrp = g.getAttribute(SPEC_ATTRIBUTE_INSTALLGROUP);
                if (instGrp == null || !selectedInstallGroup.equalsIgnoreCase(instGrp)) continue;
                group = g;
                break;
            }
        }
        if (group == null) {
            group = this.spec.getFirstChildNamed("programGroup");
        }
        String location = null;
        this.hasDesktopShortcuts = false;
        if (group != null) {
            this.suggestedProgramGroup = group.getAttribute(SPEC_ATTRIBUTE_DEFAULT_GROUP, "");
            this.programGroupIconFile = group.getAttribute(SPEC_ATTRIBUTE_ICON, "");
            this.programGroupComment = group.getAttribute("comment", "");
            location = group.getAttribute(SPEC_ATTRIBUTE_LOCATION, "applications");
        } else {
            this.suggestedProgramGroup = "";
            location = "applications";
        }
        try {
            if (location.equals("applications")) {
                this.shortcut.setLinkType(1);
            } else if (location.equals("startMenu")) {
                this.shortcut.setLinkType(2);
            }
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        List<IXMLElement> shortcutSpecs = this.spec.getChildrenNamed(SPEC_KEY_SHORTCUT);
        this.shortcuts = new ArrayList<ShortcutData>();
        this.files = new ArrayList<String>();
        this.execFiles = new ArrayList<ExecutableFile>();
        for (IXMLElement shortcutSpec : shortcutSpecs) {
            List<IXMLElement> forPacks;
            if (!this.matcher.matchesCurrentPlatform(OsConstraintHelper.getOsList(shortcutSpec))) continue;
            logger.fine("Checking Condition for " + shortcutSpec.getAttribute(SPEC_ATTRIBUTE_NAME));
            if (!this.checkConditions(shortcutSpec)) continue;
            logger.fine("Checked Condition for " + shortcutSpec.getAttribute(SPEC_ATTRIBUTE_NAME));
            ShortcutData data = new ShortcutData();
            data.name = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_NAME);
            data.subgroup = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_SUBGROUP, "");
            data.description = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_DESCRIPTION, "");
            data.deskTopEntryLinux_Encoding = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_ENCODING, "");
            data.deskTopEntryLinux_MimeType = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_MIMETYPE, "");
            data.deskTopEntryLinux_Terminal = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_TERMINAL, "");
            data.deskTopEntryLinux_TerminalOptions = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_TERMINAL_OPTIONS, "");
            data.deskTopEntryLinux_Type = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_TYPE, "");
            data.deskTopEntryLinux_URL = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_URL, "");
            data.deskTopEntryLinux_X_KDE_SubstituteUID = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_KDE_SUBST_UID, "false");
            data.deskTopEntryLinux_X_KDE_UserName = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_KDE_USERNAME, "root");
            data.Categories = shortcutSpec.getAttribute(SPEC_CATEGORIES, "");
            data.TryExec = shortcutSpec.getAttribute(SPEC_TRYEXEC, "");
            data.createForAll = Boolean.valueOf(shortcutSpec.getAttribute(CREATE_FOR_ALL, "false"));
            data.target = this.fixSeparatorChar(shortcutSpec.getAttribute(SPEC_ATTRIBUTE_TARGET, ""));
            data.commandLine = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_COMMAND, "");
            data.iconFile = this.fixSeparatorChar(shortcutSpec.getAttribute(SPEC_ATTRIBUTE_ICON, ""));
            data.iconIndex = Integer.parseInt(shortcutSpec.getAttribute(SPEC_ATTRIBUTE_ICON_INDEX, "0"));
            data.workingDirectory = this.fixSeparatorChar(shortcutSpec.getAttribute(SPEC_ATTRIBUTE_WORKING_DIR, ""));
            String initialState = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_INITIAL_STATE, "");
            data.initialState = initialState.equals(SPEC_VALUE_NO_SHOW) ? 0 : (initialState.equals(SPEC_VALUE_NORMAL) ? 1 : (initialState.equals(SPEC_VALUE_MAXIMIZED) ? 3 : (initialState.equals(SPEC_VALUE_MINIMIZED) ? 2 : 1)));
            data.runAsAdministrator = Boolean.valueOf(shortcutSpec.getAttribute(SPEC_ATTRIBUTE_RUN_AS_ADMINISTRATOR, "false"));
            if (data.name == null) continue;
            if (data.target == null) {
                data.target = "";
            }
            if (!this.shortcutRequiredFor(forPacks = shortcutSpec.getChildrenNamed(SPEC_KEY_PACKS))) continue;
            if (XMLHelper.attributeIsTrue(shortcutSpec, SPEC_ATTRIBUTE_DESKTOP)) {
                this.hasDesktopShortcuts = true;
                data.addToGroup = false;
                data.type = 3;
                this.shortcuts.add(data.clone());
            }
            if (XMLHelper.attributeIsTrue(shortcutSpec, "applications")) {
                data.addToGroup = false;
                data.type = 1;
                this.shortcuts.add(data.clone());
            }
            if (XMLHelper.attributeIsTrue(shortcutSpec, "startMenu")) {
                data.addToGroup = false;
                data.type = 2;
                this.shortcuts.add(data.clone());
            }
            if (XMLHelper.attributeIsTrue(shortcutSpec, SPEC_ATTRIBUTE_STARTUP)) {
                data.addToGroup = false;
                data.type = 4;
                this.shortcuts.add(data.clone());
            }
            if (!XMLHelper.attributeIsTrue(shortcutSpec, "programGroup")) continue;
            data.addToGroup = true;
            data.type = 1;
            this.shortcuts.add(data.clone());
        }
        if (this.shortcuts.size() > 0) {
            this.createShortcuts = true;
        }
    }

    private boolean checkConditions(IXMLElement shortcutSpec) {
        boolean result = true;
        String conditionid = shortcutSpec.getAttribute(SPEC_ATTRIBUTE_CONDITION);
        if (conditionid != null) {
            result = this.installData.getRules().isConditionTrue(conditionid);
        }
        return result;
    }

    private void createShortcuts() {
        if (!this.createShortcuts) {
            logger.warning("No shortcuts to be created");
            return;
        }
        ArrayList<String> startMenuShortcuts = new ArrayList<String>();
        for (ShortcutData data : this.shortcuts) {
            try {
                String gn = this.groupName + data.subgroup;
                this.shortcut.setUserType(this.userType);
                this.shortcut.setLinkName(data.name);
                this.shortcut.setLinkType(data.type);
                this.shortcut.setArguments(data.commandLine);
                this.shortcut.setDescription(data.description);
                this.shortcut.setIconLocation(data.iconFile, data.iconIndex);
                this.shortcut.setShowCommand(data.initialState);
                this.shortcut.setTargetPath(data.target);
                this.shortcut.setWorkingDirectory(data.workingDirectory);
                this.shortcut.setEncoding(data.deskTopEntryLinux_Encoding);
                this.shortcut.setMimetype(data.deskTopEntryLinux_MimeType);
                this.shortcut.setRunAsAdministrator(data.runAsAdministrator);
                this.shortcut.setTerminal(data.deskTopEntryLinux_Terminal);
                this.shortcut.setTerminalOptions(data.deskTopEntryLinux_TerminalOptions);
                this.shortcut.setType(data.deskTopEntryLinux_Type);
                this.shortcut.setKdeSubstUID(data.deskTopEntryLinux_X_KDE_SubstituteUID);
                this.shortcut.setKdeUserName(data.deskTopEntryLinux_X_KDE_UserName);
                this.shortcut.setURL(data.deskTopEntryLinux_URL);
                this.shortcut.setTryExec(data.TryExec);
                this.shortcut.setCategories(data.Categories);
                this.shortcut.setCreateForAll(data.createForAll);
                this.shortcut.setUninstaller(this.uninstallData);
                if (data.addToGroup) {
                    this.shortcut.setProgramGroup(gn);
                } else {
                    this.shortcut.setProgramGroup("");
                }
                try {
                    Unix_Shortcut unixcut;
                    String f;
                    if (data.type == 3 && (data.type != 3 || !this.createDesktopShortcuts)) continue;
                    this.shortcut.save();
                    if ((data.type == 1 || data.addToGroup) && this.shortcut instanceof Unix_Shortcut && (f = (unixcut = (Unix_Shortcut)this.shortcut).getWrittenFileName()) != null) {
                        startMenuShortcuts.add(f);
                    }
                    String fileName = this.shortcut.getFileName();
                    this.files.add(0, fileName);
                    File file = new File(fileName);
                    File base = new File(this.shortcut.getBasePath());
                    Vector<File> intermediates = new Vector<File>();
                    this.execFiles.add(new ExecutableFile(fileName, 2, 3, new ArrayList<OsModel>(), false));
                    this.files.add(fileName);
                    while ((file = file.getParentFile()) != null && !file.equals(base)) {
                        intermediates.add(file);
                    }
                    if (file == null) continue;
                    Enumeration filesEnum = intermediates.elements();
                    while (filesEnum.hasMoreElements()) {
                        this.files.add(0, ((File)filesEnum.nextElement()).toString());
                    }
                }
                catch (Exception exception) {
                }
            }
            catch (Throwable exception) {}
        }
        if (OsVersion.IS_UNIX) {
            this.writeXDGMenuFile(startMenuShortcuts, this.groupName, this.programGroupIconFile, this.programGroupComment);
        }
        this.shortcut.execPostAction();
        try {
            if (this.execFiles != null) {
                FileExecutor executor = new FileExecutor(this.execFiles);
            }
        }
        catch (NullPointerException nep) {
            nep.printStackTrace();
        }
        catch (RuntimeException cannot) {
            cannot.printStackTrace();
        }
        this.shortcut.cleanUp();
    }

    private String createXDGDirectory(String menuName, String icon, String comment) {
        String menuDirectoryDescriptor = "[Desktop Entry]\nName=$Name\nComment=$Comment\nIcon=$Icon\nType=Directory\nEncoding=UTF-8";
        menuDirectoryDescriptor = StringTool.replace(menuDirectoryDescriptor, "$Name", menuName);
        menuDirectoryDescriptor = StringTool.replace(menuDirectoryDescriptor, "$Comment", comment);
        menuDirectoryDescriptor = StringTool.replace(menuDirectoryDescriptor, "$Icon", icon);
        return menuDirectoryDescriptor;
    }

    private String createXDGMenu(List<String> shortcutFiles, String menuName) {
        String menuConfigText = "<Menu>\n<Name>Applications</Name>\n<Menu>\n<Directory>" + menuName.replaceAll(" ", "-") + "-izpack.directory</Directory>\n" + "<Name>" + menuName + "</Name>\n" + "<Include>\n";
        for (String shortcutFile : shortcutFiles) {
            menuConfigText = menuConfigText + "<Filename>" + shortcutFile + "</Filename>\n";
        }
        menuConfigText = menuConfigText + "</Include>\n</Menu>\n</Menu>";
        return menuConfigText;
    }

    private String fixSeparatorChar(String path) {
        String newPath = path.replace('/', File.separatorChar);
        newPath = newPath.replace('\\', File.separatorChar);
        return newPath;
    }

    private void readShortcutSpec() throws Exception {
        InputStream input = null;
        try {
            input = this.resources.getInputStream(TargetFactory.getCurrentOSPrefix() + SPEC_FILE_NAME);
        }
        catch (ResourceNotFoundException rnfE) {
            input = this.resources.getInputStream(SPEC_FILE_NAME);
        }
        if (input == null) {
            this.haveShortcutSpec = false;
            return;
        }
        VariableSubstitutorImpl replacer = new VariableSubstitutorImpl(this.installData.getVariables());
        String substitutedSpec = replacer.substitute(input, SubstitutionType.TYPE_XML);
        XMLParser parser = new XMLParser();
        this.spec = parser.parse(substitutedSpec);
        input.close();
        this.haveShortcutSpec = true;
    }

    private boolean shortcutRequiredFor(List<IXMLElement> packs) {
        if (packs.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.installData.getSelectedPacks().size(); ++i) {
            String selected = this.installData.getSelectedPacks().get(i).getName();
            for (IXMLElement pack : packs) {
                String required = pack.getAttribute(SPEC_ATTRIBUTE_NAME, "");
                if (!selected.equals(required)) continue;
                return true;
            }
        }
        return false;
    }

    private void writeString(String str, String file) {
        boolean failed = false;
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(str);
            writer.close();
        }
        catch (Exception ignore) {
            failed = true;
            logger.warning("Failed to create Gnome menu");
        }
        if (!failed) {
            this.uninstallData.addFile(file, true);
        }
    }

    private void writeXDGMenuFile(List<String> desktopFileNames, String groupName, String icon, String comment) {
        if ("".equals(this.suggestedProgramGroup) || this.suggestedProgramGroup == null) {
            return;
        }
        if (OsVersion.IS_UNIX) {
            String directoryFolder;
            String gnome3MenuFolder;
            String menuFolder;
            String menuFile = this.createXDGMenu(desktopFileNames, groupName);
            String dirFile = this.createXDGDirectory(groupName, icon, comment);
            if (this.userType == 2) {
                menuFolder = "/etc/xdg/menus/applications-merged/";
                gnome3MenuFolder = "/etc/xdg/menus/applications-gnome-merged/";
                directoryFolder = "/usr/share/desktop-directories/";
            } else {
                menuFolder = System.getProperty("user.home") + File.separator + ".config/menus/applications-merged/";
                gnome3MenuFolder = System.getProperty("user.home") + File.separator + ".config/menus/applications-gnome-merged/";
                directoryFolder = System.getProperty("user.home") + File.separator + ".local/share/desktop-directories/";
            }
            File menuFolderFile = new File(menuFolder);
            File gnome3MenuFolderFile = new File(gnome3MenuFolder);
            File directoryFolderFile = new File(directoryFolder);
            String menuFilePath = menuFolder + groupName + ".menu";
            String gnome3MenuFilePath = gnome3MenuFolder + groupName + ".menu";
            String dirFilePath = directoryFolder + groupName.replaceAll(" ", "-") + "-izpack.directory";
            menuFolderFile.mkdirs();
            gnome3MenuFolderFile.mkdirs();
            directoryFolderFile.mkdirs();
            this.writeString(menuFile, menuFilePath);
            this.writeString(menuFile, gnome3MenuFilePath);
            this.writeString(dirFile, dirFilePath);
        }
    }

    protected class LateShortcutInstallListener
    extends AbstractInstallerListener {
        protected LateShortcutInstallListener() {
        }

        @Override
        public void afterPacks(List<Pack> packs, ProgressListener listener) {
            try {
                ShortcutPanelLogic.this.createAndRegisterShortcuts();
            }
            catch (Exception exception) {
                throw new IzPackException("Failed to create shortcuts", exception);
            }
        }
    }
}

