/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.mypanels;

import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.core.resource.ResourceManager;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager2;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JCheckBox;

public class RegistryPanel
extends IzPanel {
    private static final long serialVersionUID = 4374704873970443824L;
    protected JCheckBox jcb_Associate;

    public RegistryPanel(Panel panel, InstallerFrame parent, GUIInstallData idata, ResourceManager resourceManager) {
        this(panel, parent, idata, (LayoutManager2)new BorderLayout(), resourceManager);
    }

    public RegistryPanel(Panel panel, InstallerFrame parent, GUIInstallData idata, LayoutManager2 layout, ResourceManager resourceManager) {
        super(panel, parent, idata, layout, (Resources)resourceManager);
        this.setLayout(layout);
        this.jcb_Associate = new JCheckBox(this.getString("RegistryPanel.checkbox"), true);
        this.add((Component)this.jcb_Associate, "Center");
    }

    @Override
    public void panelActivate() {
        if (!RegistryPanel.isWin()) {
            try {
                Process p1;
                Process p = Runtime.getRuntime().exec("chmod ug+x " + this.installData.getInstallPath() + File.separator + "start-seeme.sh");
                if (p.waitFor() != 0) {
                    this.emitWarning(this.getString("installer.warning"), this.getString("RegistryPanel.failed"));
                }
                if (this.installData.getAllPacks().contains("Uninstaller") && (p1 = Runtime.getRuntime().exec("chmod ug+x " + this.installData.getInstallPath() + File.separator + "uninstall.sh")).waitFor() != 0) {
                    this.emitWarning(this.getString("installer.warning"), this.getString("RegistryPanel.failed"));
                }
                try {
                    p.getErrorStream().close();
                    p.getInputStream().close();
                    p.getOutputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.emitWarning(this.getString("installer.warning"), this.getString("RegistryPanel.failed"));
            }
            catch (IOException e) {
                e.printStackTrace();
                this.emitWarning(this.getString("installer.warning"), this.getString("RegistryPanel.failed"));
            }
            this.parent.skipPanel();
        }
    }

    private static boolean isWin() {
        return System.getProperty("os.name") != null && System.getProperty("os.name").toLowerCase().contains("win");
    }

    @Override
    public boolean isValidated() {
        if (this.jcb_Associate.isSelected() && RegistryPanel.isWin()) {
            String installPath = this.installData.getInstallPath();
            StringBuffer sb = new StringBuffer();
            sb.append("Windows Registry Editor Version 5.00\n");
            sb.append("\n");
            sb.append("[HKEY_CLASSES_ROOT\\.cme]\n");
            sb.append("@=\"SeeMe.Document\"\n");
            sb.append("\n");
            sb.append("[HKEY_CLASSES_ROOT\\SeeMe.Document]\n");
            sb.append("@=\"" + this.installData.getLangpack().getString("RegistryPanel.documenttype") + "\"\n");
            sb.append("\n");
            sb.append("[HKEY_CLASSES_ROOT\\SeeMe.Document\\DefaultIcon]\n");
            sb.append("@=\"" + RegistryPanel.escape(installPath + "\\") + "SeeMeDoc.ico,0\"\n");
            sb.append("\n");
            sb.append("[HKEY_CLASSES_ROOT\\SeeMe.Document\\shell]\n");
            sb.append("\n");
            sb.append("[HKEY_CLASSES_ROOT\\SeeMe.Document\\shell\\open]\n");
            sb.append("\n");
            sb.append("[HKEY_CLASSES_ROOT\\SeeMe.Document\\shell\\open\\command]\n");
            sb.append("@=\"\\\"" + RegistryPanel.escape(installPath + "\\") + "start-seeme.exe\\\" \\\\\\\"%1\\\\\\\" \\\\\\\"%2\\\\\\\"\"\n");
            sb.append("\n");
            sb.append("[HKEY_CLASSES_ROOT\\.cmr]\n");
            sb.append("@=\"SeeMe.Rules.Document\"\n");
            sb.append("\n");
            sb.append("[HKEY_CLASSES_ROOT\\SeeMe.Rules.Document]\n");
            sb.append("@=\"" + this.getString("RegistryPanel.documenttype.rules") + "\"\n");
            sb.append("\n");
            sb.append("[HKEY_CLASSES_ROOT\\SeeMe.Rules.Document\\DefaultIcon]\n");
            sb.append("@=\"" + RegistryPanel.escape(installPath + "\\") + "SeeMeDoc.ico,0\"\n");
            sb.append("\n");
            sb.append("[HKEY_CLASSES_ROOT\\.cmp]\n");
            sb.append("@=\"SeeMe.Presentation.Document\"\n");
            sb.append("\n");
            sb.append("[HKEY_CLASSES_ROOT\\SeeMe.Presentation.Document]\n");
            sb.append("@=\"" + this.getString("RegistryPanel.documenttype.presentation") + "\"\n");
            sb.append("\n");
            sb.append("[HKEY_CLASSES_ROOT\\SeeMe.Presentation.Document\\DefaultIcon]\n");
            sb.append("@=\"" + RegistryPanel.escape(installPath + "\\") + "SeeMeDoc.ico,0\"\n");
            sb.append("\n");
            sb.append("[HKEY_CLASSES_ROOT\\.cmx]\n");
            sb.append("@=\"SeeMe.Workspace.Document\"\n");
            sb.append("\n");
            sb.append("[HKEY_CLASSES_ROOT\\SeeMe.Workspace.Document]\n");
            sb.append("@=\"" + this.getString("RegistryPanel.documenttype.workspace") + "\"\n");
            sb.append("\n");
            sb.append("[HKEY_CLASSES_ROOT\\SeeMe.Workspace.Document\\DefaultIcon]\n");
            sb.append("@=\"" + RegistryPanel.escape(installPath + "\\") + "SeeMeDoc.ico,0\"\n");
            sb.append("\n");
            sb.append("[HKEY_CLASSES_ROOT\\SeeMe.Workspace.Document\\shell]\n");
            sb.append("\n");
            sb.append("[HKEY_CLASSES_ROOT\\SeeMe.Workspace.Document\\shell\\open]\n");
            sb.append("\n");
            sb.append("[HKEY_CLASSES_ROOT\\SeeMe.Workspace.Document\\shell\\open\\command]\n");
            sb.append("@=\"" + RegistryPanel.escape(installPath + "\\") + "start-seeme.exe plugin.plugins.WorkSpaceExport#open=\\\\\\\"%1\\\\\\\" \\\\\\\"%2\\\\\\\"\"\n");
            sb.append("\n");
            sb.append("[-HKEY_CLASSES_ROOT\\Applications\\start-seeme.exe]\n");
            sb.append("\n");
            try {
                File file = File.createTempFile("dummy", "reg");
                FileWriter w = new FileWriter(file);
                w.write(sb.toString());
                w.close();
                Process p = Runtime.getRuntime().exec("regedit -s \"" + file.getAbsolutePath() + "\"");
                if (p.waitFor() != 0) {
                    this.emitWarning(this.getString("installer.warning"), this.getString("RegistryPanel.failed"));
                }
                try {
                    p.getErrorStream().close();
                    p.getInputStream().close();
                    p.getOutputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.emitWarning(this.getString("installer.warning"), this.getString("RegistryPanel.failed"));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.emitWarning(this.getString("installer.warning"), this.getString("RegistryPanel.failed"));
            }
        }
        return true;
    }

    public static CharSequence escape(CharSequence a) {
        StringBuffer s = new StringBuffer();
        block4: for (int i = 0; i < a.length(); ++i) {
            switch (a.charAt(i)) {
                case '\\': {
                    s.append("\\\\");
                    continue block4;
                }
                case '\"': {
                    s.append("\\\"");
                    continue block4;
                }
                default: {
                    s.append(a.charAt(i));
                }
            }
        }
        return s.toString();
    }
}

