/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.install;

import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.event.ProgressListener;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class InstallPanel
extends IzPanel
implements ProgressListener {
    private static final long serialVersionUID = 3257282547959410992L;
    protected JLabel tipLabel;
    protected JLabel packOpLabel;
    protected JLabel overallOpLabel;
    protected String iconName = "preferences";
    protected JProgressBar packProgressBar;
    protected JProgressBar overallProgressBar;
    private volatile boolean validated = false;
    private int noOfPacks = 0;
    private int currentStep = 0;

    public InstallPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, Log log) {
        super(panel, parent, installData, new IzPanelLayout(log), resources);
        this.tipLabel = LabelFactory.create(this.getString("InstallPanel.tip"), (Icon)parent.getIcons().get(this.iconName), 10);
        this.add((Component)this.tipLabel, IzPanelLayout.getDefaultConstraint(7));
        this.packOpLabel = LabelFactory.create(" ", 10);
        this.add((Component)this.packOpLabel, IzPanelLayout.getDefaultConstraint(7));
        this.packProgressBar = new JProgressBar();
        this.packProgressBar.setStringPainted(true);
        this.packProgressBar.setString(this.getString("InstallPanel.begin"));
        this.packProgressBar.setValue(0);
        this.add((Component)this.packProgressBar, IzPanelLayout.getDefaultConstraint(7));
        this.add(IzPanelLayout.createVerticalStrut(5));
        this.overallOpLabel = LabelFactory.create(this.getString("InstallPanel.progress"), (Icon)parent.getIcons().get(this.iconName), 10);
        this.add((Component)this.overallOpLabel, IzPanelLayout.getDefaultConstraint(7));
        this.overallProgressBar = new JProgressBar();
        this.overallProgressBar.setStringPainted(true);
        this.overallProgressBar.setString("");
        this.overallProgressBar.setValue(0);
        this.add((Component)this.overallProgressBar, IzPanelLayout.getDefaultConstraint(7));
        this.getLayoutHelper().completeLayout();
    }

    @Override
    public boolean isValidated() {
        return this.validated;
    }

    @Override
    public void startAction(String name, int noOfJobs) {
        this.noOfPacks = noOfJobs;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InstallPanel.this.parent.blockGUI();
                InstallPanel.this.overallProgressBar.setMinimum(0);
                InstallPanel.this.overallProgressBar.setMaximum(InstallPanel.this.noOfPacks);
                if (InstallPanel.this.noOfPacks == 1) {
                    InstallPanel.this.overallProgressBar.setIndeterminate(true);
                }
                InstallPanel.this.overallProgressBar.setString("0 / " + Integer.toString(InstallPanel.this.noOfPacks));
            }
        });
    }

    @Override
    public void stopAction() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InstallPanel.this.parent.releaseGUI();
                InstallPanel.this.parent.lockPrevButton();
                InstallPanel.this.overallProgressBar.setValue(InstallPanel.this.overallProgressBar.getMaximum());
                int ppbMax = InstallPanel.this.packProgressBar.getMaximum();
                if (ppbMax < 1) {
                    ppbMax = 1;
                    InstallPanel.this.packProgressBar.setMaximum(ppbMax);
                }
                InstallPanel.this.packProgressBar.setValue(ppbMax);
                if (InstallPanel.this.installData.isInstallSuccess()) {
                    InstallPanel.this.packProgressBar.setString(InstallPanel.this.getString("InstallPanel.finished"));
                } else {
                    InstallPanel.this.packProgressBar.setString(InstallPanel.this.getString("installer.error"));
                }
                InstallPanel.this.packProgressBar.setEnabled(false);
                String no_of_packs = Integer.toString(InstallPanel.this.noOfPacks);
                if (InstallPanel.this.noOfPacks == 1) {
                    InstallPanel.this.overallProgressBar.setIndeterminate(false);
                }
                InstallPanel.this.overallProgressBar.setString(no_of_packs + " / " + no_of_packs);
                InstallPanel.this.overallProgressBar.setEnabled(false);
                InstallPanel.this.packOpLabel.setText(" ");
                InstallPanel.this.packOpLabel.setEnabled(false);
                InstallPanel.this.installData.setCanClose(true);
                InstallPanel.this.validated = true;
                if (InstallPanel.this.installData.isInstallSuccess() && InstallPanel.this.installData.getPanels().indexOf(InstallPanel.this) != InstallPanel.this.installData.getPanels().size() - 1) {
                    InstallPanel.this.parent.unlockNextButton();
                }
            }
        });
    }

    @Override
    public void progress(final int val, final String msg) {
        ++this.currentStep;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InstallPanel.this.packProgressBar.setValue(val + 1);
                InstallPanel.this.packOpLabel.setText(msg);
            }
        });
    }

    @Override
    public void nextStep(final String packName, final int stepno, final int max) {
        this.currentStep = 0;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InstallPanel.this.packProgressBar.setValue(0);
                InstallPanel.this.packProgressBar.setMinimum(0);
                InstallPanel.this.packProgressBar.setMaximum(max);
                InstallPanel.this.packProgressBar.setString(packName);
                InstallPanel.this.overallProgressBar.setValue(stepno - 1);
                InstallPanel.this.overallProgressBar.setString(Integer.toString(stepno) + " / " + Integer.toString(InstallPanel.this.noOfPacks));
            }
        });
    }

    @Override
    public void setSubStepNo(final int no_of_substeps) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InstallPanel.this.packProgressBar.setMaximum(no_of_substeps);
            }
        });
    }

    @Override
    public void restartAction(String name, String overallMessage, String tip, int steps) {
        this.overallOpLabel.setText(overallMessage);
        this.tipLabel.setText(tip);
        this.currentStep = 0;
        this.startAction(name, steps);
    }

    @Override
    public void progress(String message) {
        this.packOpLabel.setText(message);
        ++this.currentStep;
        this.packProgressBar.setValue(this.currentStep);
    }

    @Override
    public void panelActivate() {
        Dimension dimension = this.parent.getPanelsContainerSize();
        dimension.width -= dimension.width / 4;
        dimension.height = 150;
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setPreferredSize(dimension);
        this.parent.lockNextButton();
        this.parent.lockPrevButton();
        this.parent.install(this);
    }
}

