/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.unpacker;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.OverrideType;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.event.ProgressListener;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.exception.ResourceInterruptedException;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.core.handler.ProgressHandler;
import com.izforge.izpack.data.ExecutableFile;
import com.izforge.izpack.data.ParsableFile;
import com.izforge.izpack.data.UpdateCheck;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.installer.event.InstallerListeners;
import com.izforge.izpack.installer.unpacker.Cancellable;
import com.izforge.izpack.installer.unpacker.DefaultFileUnpacker;
import com.izforge.izpack.installer.unpacker.FileQueueFactory;
import com.izforge.izpack.installer.unpacker.FileUnpacker;
import com.izforge.izpack.installer.unpacker.IUnpacker;
import com.izforge.izpack.installer.unpacker.LooseFileUnpacker;
import com.izforge.izpack.installer.unpacker.Pack200FileUnpacker;
import com.izforge.izpack.installer.unpacker.PackResources;
import com.izforge.izpack.installer.unpacker.ScriptParser;
import com.izforge.izpack.installer.util.PackHelper;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.PlatformModelMatcher;
import com.izforge.izpack.util.file.DirectoryScanner;
import com.izforge.izpack.util.file.FileUtils;
import com.izforge.izpack.util.file.GlobPatternMapper;
import com.izforge.izpack.util.file.types.FileSet;
import com.izforge.izpack.util.os.FileQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.jar.Pack200;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class UnpackerBase
implements IUnpacker {
    private final InstallData installData;
    private final UninstallData uninstallData;
    private final PackResources resources;
    private final RulesEngine rules;
    private final VariableSubstitutor variableSubstitutor;
    private final FileQueueFactory queueFactory;
    private final Housekeeper housekeeper;
    private final InstallerListeners listeners;
    private ProgressListener listener;
    private File absoluteInstallSource;
    private Pack200.Unpacker unpacker;
    private final Prompt prompt;
    private final PlatformModelMatcher matcher;
    private boolean result = true;
    private final Cancellable cancellable;
    private State state = State.READY;
    private boolean disableInterrupt = false;
    private static final Logger logger = Logger.getLogger(UnpackerBase.class.getName());

    public UnpackerBase(InstallData installData, PackResources resources, RulesEngine rules, VariableSubstitutor variableSubstitutor, UninstallData uninstallData, FileQueueFactory factory, Housekeeper housekeeper, InstallerListeners listeners, Prompt prompt, PlatformModelMatcher matcher) {
        this.installData = installData;
        this.resources = resources;
        this.rules = rules;
        this.variableSubstitutor = variableSubstitutor;
        this.uninstallData = uninstallData;
        this.queueFactory = factory;
        this.housekeeper = housekeeper;
        this.listeners = listeners;
        this.prompt = prompt;
        this.matcher = matcher;
        this.cancellable = new Cancellable(){

            @Override
            public boolean isCancelled() {
                return UnpackerBase.this.isInterrupted();
            }
        };
    }

    @Override
    public void setProgressListener(ProgressListener listener) {
        this.listener = listener;
    }

    @Override
    public void run() {
        this.unpack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpack() {
        this.state = State.UNPACKING;
        try {
            ArrayList<ParsableFile> parsables = new ArrayList<ParsableFile>();
            ArrayList<ExecutableFile> executables = new ArrayList<ExecutableFile>();
            ArrayList<UpdateCheck> updateChecks = new ArrayList<UpdateCheck>();
            FileQueue queue = this.queueFactory.isSupported() ? this.queueFactory.create() : null;
            List<Pack> packs = this.installData.getSelectedPacks();
            this.preUnpack(packs);
            this.unpack(packs, queue, parsables, executables, updateChecks);
            this.postUnpack(packs, queue, parsables, executables, updateChecks);
        }
        catch (Exception exception) {
            this.setResult(false);
            logger.log(Level.SEVERE, exception.getMessage(), exception);
            this.listener.stopAction();
            if (exception instanceof ResourceInterruptedException) {
                this.prompt.message(Prompt.Type.INFORMATION, "Installation cancelled");
            } else {
                String message = exception.getMessage();
                if (message == null || "".equals(message)) {
                    message = "Internal error occurred : " + exception.toString();
                }
                this.prompt.message(Prompt.Type.ERROR, message);
            }
            this.housekeeper.shutDown(4);
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    public boolean getResult() {
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean interrupt(long timeout) {
        boolean result;
        if (this.isInterruptDisabled()) {
            result = false;
        } else {
            UnpackerBase unpackerBase = this;
            synchronized (unpackerBase) {
                if (this.state != State.READY && this.state != State.INTERRUPTED) {
                    this.state = State.INTERRUPT;
                    try {
                        this.wait(timeout);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    result = this.state == State.INTERRUPTED;
                } else {
                    result = true;
                }
            }
        }
        return result;
    }

    @Override
    public synchronized void setDisableInterrupt(boolean disable) {
        if (this.state == State.INTERRUPT || this.state == State.INTERRUPTED) {
            throw new IllegalStateException("Cannot disable interrupts. Unpacking has already been interrupted");
        }
        this.disableInterrupt = disable;
    }

    @Override
    public synchronized boolean isInterruptDisabled() {
        return this.disableInterrupt;
    }

    protected void preUnpack(List<Pack> packs) {
        logger.fine("Unpacker starting");
        this.listener.startAction("Unpacking", packs.size());
        this.listeners.beforePacks(packs, this.listener);
    }

    protected void unpack(List<Pack> packs, FileQueue queue, List<ParsableFile> parsables, List<ExecutableFile> executables, List<UpdateCheck> updateChecks) {
        int count = packs.size();
        for (int i = 0; i < count; ++i) {
            Pack pack = packs.get(i);
            if (!this.shouldUnpack(pack)) continue;
            this.listeners.beforePack(pack, i, this.listener);
            this.unpack(pack, i, queue, parsables, executables, updateChecks);
            this.checkInterrupt();
            this.listeners.afterPack(pack, i, this.listener);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void unpack(Pack pack, int packNo, FileQueue queue, List<ParsableFile> parsables, List<ExecutableFile> executables, List<UpdateCheck> updateChecks) {
        InputStream in = null;
        ObjectInputStream packInputStream = null;
        try {
            in = this.resources.getPackStream(pack.getName());
            packInputStream = new ObjectInputStream(in);
            int fileCount = packInputStream.readInt();
            String stepName = this.getStepName(pack);
            this.listener.nextStep(stepName, packNo + 1, fileCount);
            for (int i = 0; i < fileCount; ++i) {
                PackFile file = (PackFile)packInputStream.readObject();
                if (this.shouldUnpack(file)) {
                    this.unpack(file, packInputStream, i, pack, queue);
                    continue;
                }
                this.skip(file, pack, packInputStream);
            }
            this.readParsableFiles(packInputStream, parsables);
            this.readExecutableFiles(packInputStream, executables);
            this.readUpdateChecks(packInputStream, updateChecks);
        }
        catch (IzPackException exception) {
            try {
                throw exception;
                catch (Exception exception2) {
                    throw new InstallerException("Failed to unpack pack: " + pack.getName(), exception2);
                }
            }
            catch (Throwable throwable) {
                FileUtils.close(packInputStream);
                FileUtils.close(in);
                throw throwable;
            }
        }
        FileUtils.close(packInputStream);
        FileUtils.close(in);
    }

    private boolean shouldUnpack(PackFile file) {
        boolean result = true;
        if (file.hasCondition()) {
            result = this.isConditionTrue(file.getCondition());
        }
        if (result && file.osConstraints() != null && !file.osConstraints().isEmpty()) {
            result = this.matcher.matchesCurrentPlatform(file.osConstraints());
        }
        return result;
    }

    protected void unpack(PackFile file, ObjectInputStream packInputStream, int fileNo, Pack pack, FileQueue queue) throws IOException {
        File target;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Unpack " + file.getTargetPath());
        }
        Variables variables = this.getInstallData().getVariables();
        String path = IoHelper.translatePath(file.getTargetPath(), variables);
        File dir = target = new File(path);
        if (!file.isDirectory()) {
            dir = target.getParentFile();
        }
        this.createDirectory(dir, file, pack);
        this.getUninstallData().addFile(path, pack.isUninstall());
        if (file.isDirectory()) {
            return;
        }
        this.listeners.beforeFile(target, file, pack);
        this.listener.progress(fileNo, path);
        if (target.exists() && file.override() != OverrideType.OVERRIDE_TRUE && !this.isOverwriteFile(file, target)) {
            if (!file.isBackReference() && !pack.isLoose()) {
                if (file.isPack200Jar()) {
                    this.skip(packInputStream, 4L);
                } else {
                    this.skip(packInputStream, file.length());
                }
            }
        } else {
            this.handleOverrideRename(file, target);
            this.extract(file, target, packInputStream, pack, queue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extract(PackFile file, File target, ObjectInputStream packInputStream, Pack pack, FileQueue queue) throws IOException {
        InputStream in;
        ObjectInputStream packStream;
        block5: {
            packStream = packInputStream;
            in = null;
            try {
                if (!pack.isLoose() && file.isBackReference()) {
                    in = this.resources.getPackStream(file.previousPackId);
                    packStream = new ObjectInputStream(in);
                    this.skip(in, file.offsetInPreviousPack - 4L);
                }
                FileUnpacker unpacker = this.createFileUnpacker(file, pack, queue, this.cancellable);
                unpacker.unpack(file, packStream, target);
                this.checkInterrupt();
                if (unpacker.isQueued()) break block5;
                this.listeners.afterFile(target, file, pack);
            }
            catch (Throwable throwable) {
                FileUtils.close(in);
                if (packStream != packInputStream) {
                    FileUtils.close(packStream);
                }
                throw throwable;
            }
        }
        FileUtils.close(in);
        if (packStream != packInputStream) {
            FileUtils.close(packStream);
        }
    }

    protected void skip(PackFile file, Pack pack, ObjectInputStream packInputStream) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Skip " + file.getTargetPath());
        }
        if (!pack.isLoose() && !file.isBackReference()) {
            this.skip(packInputStream, file.length());
        }
    }

    protected FileUnpacker createFileUnpacker(PackFile file, Pack pack, FileQueue queue, Cancellable cancellable) throws IOException, InstallerException {
        FileUnpacker unpacker = pack.isLoose() ? new LooseFileUnpacker(this.getAbsoluteInstallSource(), cancellable, queue, this.prompt) : (file.isPack200Jar() ? new Pack200FileUnpacker(cancellable, this.resources, this.getPack200Unpacker(), queue) : new DefaultFileUnpacker(cancellable, queue));
        return unpacker;
    }

    protected void postUnpack(List<Pack> packs, FileQueue queue, List<ParsableFile> parsables, List<ExecutableFile> executables, List<UpdateCheck> updateChecks) throws IOException {
        InstallData installData = this.getInstallData();
        if (queue != null && !queue.isEmpty()) {
            queue.execute();
            installData.setRebootNecessary(queue.isRebootNecessary());
        }
        this.checkInterrupt();
        this.parseFiles(parsables);
        this.checkInterrupt();
        this.executeFiles(executables);
        this.checkInterrupt();
        this.performUpdateChecks(updateChecks);
        this.checkInterrupt();
        this.listeners.afterPacks(packs, this.listener);
        this.checkInterrupt();
        this.writeInstallationInformation();
        this.listener.stopAction();
    }

    protected void cleanup() {
        this.state = State.READY;
    }

    protected InstallData getInstallData() {
        return this.installData;
    }

    protected UninstallData getUninstallData() {
        return this.uninstallData;
    }

    protected PackResources getResources() {
        return this.resources;
    }

    protected VariableSubstitutor getVariableSubstitutor() {
        return this.variableSubstitutor;
    }

    protected ProgressListener getProgressListener() {
        return this.listener;
    }

    protected Prompt getPrompt() {
        return this.prompt;
    }

    protected boolean shouldUnpack(Pack pack) {
        boolean result = true;
        if (pack.hasCondition()) {
            result = this.rules.isConditionTrue(pack.getCondition());
        }
        return result;
    }

    protected void setResult(boolean result) {
        this.result = result;
    }

    protected boolean isConditionTrue(String id) {
        return this.rules.isConditionTrue(id);
    }

    protected String getStepName(Pack pack) {
        return pack.isHidden() ? "" : PackHelper.getPackName(pack, this.installData.getMessages());
    }

    protected void createDirectory(File dir, PackFile file, Pack pack) {
        if (!dir.exists()) {
            if (!this.listeners.isFileListener()) {
                if (!dir.mkdirs()) {
                    throw new IzPackException("Could not create directory: " + dir.getPath());
                }
            } else {
                File parent = dir.getParentFile();
                if (parent != null) {
                    this.createDirectory(parent, file, pack);
                }
                this.listeners.beforeDir(dir, file, pack);
                if (!dir.mkdir()) {
                    throw new IzPackException("Could not create directory: " + dir.getPath());
                }
                this.listeners.afterDir(dir, file, pack);
            }
        }
    }

    private void parseFiles(List<ParsableFile> files) {
        if (!files.isEmpty()) {
            ScriptParser parser = new ScriptParser(this.getVariableSubstitutor(), this.matcher);
            for (ParsableFile file : files) {
                try {
                    parser.parse(file);
                }
                catch (Exception exception) {
                    throw new InstallerException("Failed to parse: " + file.getPath(), exception);
                }
                this.checkInterrupt();
            }
        }
    }

    private void executeFiles(List<ExecutableFile> executables) {
        ProgressHandler handler;
        FileExecutor executor;
        if (!executables.isEmpty() && (executor = new FileExecutor(executables)).executeFiles(0, this.matcher, handler = new ProgressHandler(this.listener, this.prompt)) != 0) {
            throw new InstallerException("File execution failed");
        }
    }

    protected synchronized boolean isInterrupted() {
        boolean result = false;
        if (this.state == State.INTERRUPT) {
            this.setResult(false);
            this.state = State.INTERRUPTED;
            result = true;
            this.notifyAll();
        } else if (this.state == State.INTERRUPTED) {
            result = true;
        }
        return result;
    }

    protected void checkInterrupt() {
        if (this.isInterrupted()) {
            throw new ResourceInterruptedException("Installation cancelled");
        }
    }

    protected void performUpdateChecks(List<UpdateCheck> checks) {
        if (checks != null && !checks.isEmpty()) {
            File[] files;
            File d;
            logger.info("Cleaning up the target folder ...");
            File absoluteInstallPath = new File(this.installData.getInstallPath()).getAbsoluteFile();
            FileSet fileset = new FileSet();
            ArrayList<File> filesToDelete = new ArrayList<File>();
            ArrayList<File> dirsToDelete = new ArrayList<File>();
            try {
                fileset.setDir(absoluteInstallPath);
                for (UpdateCheck check : checks) {
                    if (check.includesList != null) {
                        for (String include : check.includesList) {
                            fileset.createInclude().setName(this.variableSubstitutor.substitute(include));
                        }
                    }
                    if (check.excludesList == null) continue;
                    for (String exclude : check.excludesList) {
                        fileset.createExclude().setName(this.variableSubstitutor.substitute(exclude));
                    }
                }
                DirectoryScanner scanner = fileset.getDirectoryScanner();
                scanner.scan();
                String[] srcFiles = scanner.getIncludedFiles();
                String[] srcDirs = scanner.getIncludedDirectories();
                TreeSet<File> installedFiles = new TreeSet<File>();
                for (String name : this.uninstallData.getInstalledFilesList()) {
                    File file = new File(name);
                    if (!file.isAbsolute()) {
                        file = new File(absoluteInstallPath, name);
                    }
                    installedFiles.add(file);
                }
                for (String srcFile : srcFiles) {
                    File newFile = new File(scanner.getBasedir(), srcFile);
                    if (installedFiles.contains(newFile)) continue;
                    filesToDelete.add(newFile);
                }
                for (String srcDir : srcDirs) {
                    File newDir;
                    if (srcDir.isEmpty() || installedFiles.contains(newDir = new File(scanner.getBasedir(), srcDir))) continue;
                    dirsToDelete.add(newDir);
                }
            }
            catch (IzPackException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new IzPackException(exception);
            }
            for (File f : filesToDelete) {
                if (!f.delete()) {
                    logger.warning("Cleanup: Unable to delete file " + f);
                    continue;
                }
                logger.fine("Cleanup: Deleted file " + f);
            }
            Collections.sort(dirsToDelete);
            Collections.reverse(dirsToDelete);
            Iterator<UpdateCheck> i$ = dirsToDelete.iterator();
            while (i$.hasNext() && (d = (File)((Object)i$.next())).exists() && ((files = d.listFiles()) == null || files.length == 0)) {
                if (!d.delete()) {
                    logger.warning("Cleanup: Unable to delete directory " + d);
                    continue;
                }
                logger.fine("Cleanup: Deleted directory " + d);
            }
        }
    }

    protected void writeInstallationInformation() throws IOException {
        if (!this.installData.getInfo().isWriteInstallationInformation()) {
            logger.fine("Skip writing installation information");
            return;
        }
        logger.fine("Writing installation information");
        String installDir = this.installData.getInstallPath();
        ArrayList<Pack> installedPacks = new ArrayList<Pack>(this.installData.getSelectedPacks());
        File installationInfo = new File(installDir + File.separator + ".installationinformation");
        if (!installationInfo.exists()) {
            logger.fine("Creating info file" + installationInfo.getAbsolutePath());
            File dir = new File(this.installData.getInstallPath());
            if (!dir.exists() && !dir.mkdirs()) {
                throw new InstallerException("Failed to create directory: " + dir);
            }
            if (!installationInfo.createNewFile()) {
                throw new InstallerException("Failed to create file: " + installationInfo);
            }
        } else {
            List packs;
            logger.fine("Previous installation information found");
            FileInputStream fin = new FileInputStream(installationInfo);
            ObjectInputStream oin = new ObjectInputStream(fin);
            try {
                packs = (List)oin.readObject();
            }
            catch (Exception exception) {
                throw new InstallerException("Failed to read previous installation information", exception);
            }
            for (Pack pack : packs) {
                installedPacks.add(pack);
            }
            FileUtils.close(oin);
            FileUtils.close(fin);
        }
        FileOutputStream fout = new FileOutputStream(installationInfo);
        ObjectOutputStream oout = new ObjectOutputStream(fout);
        oout.writeObject(installedPacks);
        oout.writeObject(this.installData.getVariables().getProperties());
        logger.fine("Writing installation information finished");
        FileUtils.close(oout);
        FileUtils.close(fout);
    }

    protected File getAbsoluteInstallSource() throws IOException, InstallerException {
        if (this.absoluteInstallSource == null) {
            URI uri;
            try {
                uri = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
            }
            catch (URISyntaxException exception) {
                throw new InstallerException(exception);
            }
            if (!"file".equals(uri.getScheme())) {
                throw new InstallerException("Unexpected scheme in JAR file URI: " + uri);
            }
            this.absoluteInstallSource = new File(uri.getSchemeSpecificPart()).getAbsoluteFile();
            if (this.absoluteInstallSource.getName().endsWith(".jar")) {
                this.absoluteInstallSource = this.absoluteInstallSource.getParentFile();
            }
        }
        return this.absoluteInstallSource;
    }

    protected void skip(InputStream stream, long bytes) throws IOException {
        long skipped = stream.skip(bytes);
        if (skipped != bytes) {
            throw new IOException("Expected to skip: " + bytes + " in stream but skipped: " + skipped);
        }
    }

    protected boolean isOverwriteFile(PackFile pf, File file) {
        boolean result = false;
        if (pf.override() != OverrideType.OVERRIDE_FALSE) {
            if (pf.override() == OverrideType.OVERRIDE_TRUE) {
                result = true;
            } else if (pf.override() == OverrideType.OVERRIDE_UPDATE) {
                result = file.lastModified() < pf.lastModified();
            } else {
                Prompt.Option defChoice = null;
                if (pf.override() == OverrideType.OVERRIDE_ASK_FALSE) {
                    defChoice = Prompt.Option.NO;
                } else if (pf.override() == OverrideType.OVERRIDE_ASK_TRUE) {
                    defChoice = Prompt.Option.YES;
                }
                Messages messages = this.installData.getMessages();
                Prompt.Option answer = this.prompt.confirm(Prompt.Type.QUESTION, messages.get("InstallPanel.overwrite.title", new Object[0]) + " - " + file.getName(), messages.get("InstallPanel.overwrite.question", new Object[0]) + file.getAbsolutePath(), Prompt.Options.YES_NO, defChoice);
                result = answer == Prompt.Option.YES;
            }
        }
        return result;
    }

    protected void handleOverrideRename(PackFile pf, File file) {
        if (file.exists() && pf.overrideRenameTo() != null) {
            GlobPatternMapper mapper = new GlobPatternMapper();
            mapper.setFrom("*");
            mapper.setTo(pf.overrideRenameTo());
            mapper.setCaseSensitive(true);
            String[] newFileNameArr = mapper.mapFileName(file.getName());
            if (newFileNameArr != null) {
                String newFileName = newFileNameArr[0];
                File newPathFile = new File(file.getParent(), newFileName);
                if (newPathFile.exists() && !newPathFile.delete()) {
                    logger.warning("Failed to delete: " + newPathFile);
                }
                if (!file.renameTo(newPathFile)) {
                    throw new InstallerException("The file " + file + " could not be renamed to " + newPathFile);
                }
            } else {
                throw new InstallerException("File name " + file.getName() + " cannot be mapped using the expression \"" + pf.overrideRenameTo() + "\"");
            }
        }
    }

    protected void readParsableFiles(ObjectInputStream stream, List<ParsableFile> parsables) throws IOException, ClassNotFoundException {
        int count = stream.readInt();
        for (int i = 0; i < count; ++i) {
            ParsableFile file = (ParsableFile)stream.readObject();
            if (file.hasCondition() && !this.isConditionTrue(file.getCondition())) continue;
            String path = IoHelper.translatePath(file.getPath(), this.installData.getVariables());
            file.setPath(path);
            parsables.add(file);
        }
    }

    protected void readExecutableFiles(ObjectInputStream stream, List<ExecutableFile> executables) throws IOException, ClassNotFoundException {
        int count = stream.readInt();
        for (int i = 0; i < count; ++i) {
            ExecutableFile file = (ExecutableFile)stream.readObject();
            if (file.hasCondition() && !this.isConditionTrue(file.getCondition())) continue;
            Variables variables = this.installData.getVariables();
            file.path = IoHelper.translatePath(file.path, variables);
            if (null != file.argList && !file.argList.isEmpty()) {
                for (int j = 0; j < file.argList.size(); ++j) {
                    String arg = file.argList.get(j);
                    arg = IoHelper.translatePath(arg, variables);
                    file.argList.set(j, arg);
                }
            }
            executables.add(file);
            if (file.executionStage != 2) continue;
            this.uninstallData.addExecutable(file);
        }
    }

    protected void readUpdateChecks(ObjectInputStream stream, List<UpdateCheck> updateChecks) throws IOException, ClassNotFoundException {
        int count = stream.readInt();
        for (int i = 0; i < count; ++i) {
            UpdateCheck check = (UpdateCheck)stream.readObject();
            updateChecks.add(check);
        }
    }

    private Pack200.Unpacker getPack200Unpacker() {
        if (this.unpacker == null) {
            this.unpacker = Pack200.newUnpacker();
        }
        return this.unpacker;
    }

    private static enum State {
        READY,
        UNPACKING,
        INTERRUPT,
        INTERRUPTED;

    }
}

