/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.panel;

import com.izforge.izpack.api.data.DynamicInstallerRequirementValidator;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.api.factory.ObjectFactory;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.api.installer.DataValidator;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.data.PanelAction;
import com.izforge.izpack.installer.panel.PanelView;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractPanelView<T>
implements PanelView<T> {
    private final Panel panel;
    private final Class<T> viewClass;
    private final ObjectFactory factory;
    private int index;
    private T view;
    private boolean visible = true;
    private DataValidator validator;
    private final InstallData installData;
    private final List<PanelAction> preActivationActions = new ArrayList<PanelAction>();
    private final List<PanelAction> preValidationActions = new ArrayList<PanelAction>();
    private final List<PanelAction> postValidationActions = new ArrayList<PanelAction>();
    private static final Logger logger = Logger.getLogger(AbstractPanelView.class.getName());

    public AbstractPanelView(Panel panel, Class<T> viewClass, ObjectFactory factory, InstallData installData) {
        this.panel = panel;
        this.viewClass = viewClass;
        this.factory = factory;
        this.installData = installData;
    }

    @Override
    public String getPanelId() {
        return this.panel.getPanelId();
    }

    @Override
    public Panel getPanel() {
        return this.panel;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public T getView() {
        if (this.view == null) {
            this.executePreConstructionActions();
            this.view = this.createView(this.panel, this.viewClass);
            String dataValidator = this.panel.getValidator();
            if (dataValidator != null) {
                this.validator = this.factory.create(dataValidator, DataValidator.class, this.panel, this.view);
            }
            this.addActions(this.panel.getPreActivationActions(), this.preActivationActions, PanelAction.ActionStage.preactivate);
            this.addActions(this.panel.getPreValidationActions(), this.preValidationActions, PanelAction.ActionStage.prevalidate);
            this.addActions(this.panel.getPostValidationActions(), this.postValidationActions, PanelAction.ActionStage.postvalidate);
            this.initialise(this.view, this.panel, this.installData);
        }
        return this.view;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean isValid() {
        boolean result = false;
        this.installData.getVariables().refresh();
        this.executePreValidationActions();
        List<DynamicInstallerRequirementValidator> conditions = this.installData.getDynamicInstallerRequirements();
        if (conditions == null || this.validateDynamicConditions()) {
            result = this.validator == null || this.validateData();
        }
        this.executePostValidationActions();
        return result;
    }

    @Override
    public boolean canShow() {
        String panelId = this.panel.getPanelId();
        this.installData.refreshVariables();
        boolean result = this.panel.hasCondition() ? this.installData.getRules().isConditionTrue(this.panel.getCondition()) : this.installData.getRules().canShowPanel(panelId, this.installData.getVariables());
        return result;
    }

    public void executePreActivationActions() {
        this.execute(this.preActivationActions);
    }

    public void executePreValidationActions() {
        this.execute(this.preValidationActions);
    }

    public void executePostValidationActions() {
        this.execute(this.postValidationActions);
    }

    protected abstract AbstractUIHandler getHandler();

    protected T createView(Panel panel, Class<T> viewClass) {
        return this.factory.create(panel.getClassName(), viewClass, panel, this);
    }

    protected void initialise(T view, Panel panel, InstallData installData) {
    }

    protected boolean validateDynamicConditions() {
        boolean result = true;
        try {
            this.installData.refreshVariables();
            for (DynamicInstallerRequirementValidator validator : this.installData.getDynamicInstallerRequirements()) {
                if (this.isValid(validator, this.installData)) continue;
                result = false;
                break;
            }
        }
        catch (Throwable exception) {
            logger.log(Level.WARNING, "Could not validate dynamic conditions", exception);
            result = false;
        }
        return result;
    }

    protected boolean validateData() {
        return this.isValid(this.validator, this.installData);
    }

    private boolean isValid(DataValidator validator, InstallData installData) {
        boolean result = false;
        DataValidator.Status status = validator.validateData(installData);
        logger.fine("Data validation status=" + (Object)((Object)status) + ", for validator=" + validator.getClass().getName());
        if (status == DataValidator.Status.OK) {
            result = true;
        } else if (status == DataValidator.Status.WARNING) {
            String message = this.getMessage(validator.getWarningMessageId(), true);
            if (message == null) {
                logger.warning("No warning message for validator=" + validator.getClass().getName());
            }
            result = this.isWarningValid(message, validator.getDefaultAnswer());
        } else {
            String message = this.getMessage(validator.getErrorMessageId(), true);
            if (message == null) {
                logger.warning("No error message for validator=" + validator.getClass().getName());
                message = "Validation error";
            }
            this.getHandler().emitError(this.getMessage("data.validation.error.title"), message);
        }
        return result;
    }

    protected boolean isWarningValid(String message, boolean defaultAnswer) {
        boolean result = false;
        if (message != null) {
            if (this.getHandler().emitWarning(this.getMessage("data.validation.warning.title"), message)) {
                result = true;
                logger.fine("User decided to skip validation warning");
            }
        } else {
            logger.fine("No warning message available, using default answer=" + defaultAnswer);
            result = defaultAnswer;
        }
        return result;
    }

    protected ObjectFactory getFactory() {
        return this.factory;
    }

    protected String getMessage(String id) {
        return this.getMessage(id, false);
    }

    private void execute(List<PanelAction> actions) {
        AbstractUIHandler handler = this.getHandler();
        for (PanelAction action : actions) {
            action.executeAction(this.installData, handler);
        }
    }

    private void executePreConstructionActions() {
        List<PanelActionConfiguration> configurations = this.panel.getPreConstructionActions();
        if (configurations != null) {
            for (PanelActionConfiguration config : configurations) {
                PanelAction action = this.factory.create(config.getActionClassName(), PanelAction.class, new Object[]{this.panel, PanelAction.ActionStage.preconstruct});
                action.initialize(config);
                action.executeAction(this.installData, null);
            }
        }
    }

    private void addActions(List<PanelActionConfiguration> configurations, List<PanelAction> actions, PanelAction.ActionStage stage) {
        if (configurations != null) {
            for (PanelActionConfiguration config : configurations) {
                PanelAction action = this.factory.create(config.getActionClassName(), PanelAction.class, new Object[]{this.panel, this.view, stage});
                action.initialize(config);
                actions.add(action);
            }
        }
    }

    private String getMessage(String id, boolean replace) {
        String message = null;
        if (id != null) {
            Messages messages = this.installData.getMessages();
            message = messages.get(id, new Object[0]);
            if (replace) {
                message = this.installData.getVariables().replace(message);
            }
        }
        return message;
    }
}

