/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.event.ProgressListener;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.exception.NativeLibException;
import com.izforge.izpack.api.exception.ResourceNotFoundException;
import com.izforge.izpack.api.exception.WrappedNativeLibException;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.core.os.RegistryDefaultHandler;
import com.izforge.izpack.core.os.RegistryHandler;
import com.izforge.izpack.event.AbstractProgressInstallerListener;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.installer.unpacker.IUnpacker;
import com.izforge.izpack.util.CleanupClient;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.file.FileUtils;
import com.izforge.izpack.util.helper.SpecHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RegistryInstallerListener
extends AbstractProgressInstallerListener
implements CleanupClient {
    private static final Logger logger = Logger.getLogger(RegistryInstallerListener.class.getName());
    static final String SPEC_FILE_NAME = "RegistrySpec.xml";
    private static final String REG_KEY = "key";
    private static final String REG_VALUE = "value";
    private static final String REG_ROOT = "root";
    private static final String REG_BASENAME = "name";
    private static final String REG_KEYPATH = "keypath";
    private static final String REG_DWORD = "dword";
    private static final String REG_STRING = "string";
    private static final String REG_MULTI = "multi";
    private static final String REG_BIN = "bin";
    private static final String REG_DATA = "data";
    private static final String REG_OVERRIDE = "override";
    private static final String SAVE_PREVIOUS = "saveprevious";
    private List registryModificationLog;
    private IUnpacker unpacker;
    private VariableSubstitutor substituter;
    private final UninstallData uninstallData;
    private final Resources resources;
    private final RulesEngine rules;
    private final Housekeeper housekeeper;
    private final RegistryHandler registry;
    private final SpecHelper spec;
    static final String UNINSTALLER_ICON = "UninstallerIcon";

    public RegistryInstallerListener(IUnpacker unpacker, VariableSubstitutor substituter, InstallData installData, UninstallData uninstallData, Resources resources, RulesEngine rules, Housekeeper housekeeper, RegistryDefaultHandler handler) {
        super(installData);
        this.substituter = substituter;
        this.unpacker = unpacker;
        this.uninstallData = uninstallData;
        this.resources = resources;
        this.rules = rules;
        this.housekeeper = housekeeper;
        this.registry = handler.getInstance();
        this.spec = new SpecHelper(resources);
    }

    @Override
    public void initialise() {
        if (this.registry != null) {
            String uninstallName = this.getUninstallName();
            this.registry.setUninstallName(uninstallName);
        }
    }

    @Override
    public void afterPacks(List<Pack> packs, ProgressListener listener) {
        if (this.registry != null) {
            try {
                this.spec.readSpec(SPEC_FILE_NAME, this.substituter);
            }
            catch (Exception exception) {
                throw new IzPackException("Failed to read: RegistrySpec.xml", exception);
            }
            try {
                this.afterPacks(packs);
            }
            catch (NativeLibException e) {
                throw new WrappedNativeLibException(e, this.getInstallData().getMessages());
            }
        }
    }

    @Override
    public void cleanUp() {
        InstallData installData;
        if (this.registry != null && !(installData = this.getInstallData()).isInstallSuccess() && this.registryModificationLog != null && !this.registryModificationLog.isEmpty()) {
            try {
                this.registry.activateLogging();
                this.registry.setLoggingInfo(this.registryModificationLog);
                this.registry.rewind();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected String getUninstallName() {
        Variables variables = this.getInstallData().getVariables();
        return variables.get("APP_NAME") + " " + variables.get("APP_VER");
    }

    private void afterPacks(List<Pack> packs) throws NativeLibException, InstallerException {
        List<Object> info;
        String uninstallSuffix;
        this.housekeeper.registerForCleanup(this);
        IXMLElement uninstallerPack = null;
        this.unpacker.setDisableInterrupt(true);
        this.registry.activateLogging();
        if (this.spec.getSpec() != null) {
            uninstallerPack = this.spec.getPackForName("UninstallStuff");
            this.performPack(uninstallerPack);
            for (Pack selectedPack : packs) {
                IXMLElement pack = this.spec.getPackForName(selectedPack.getName());
                this.performPack(pack);
            }
        }
        if ((uninstallSuffix = this.getInstallData().getVariable("UninstallKeySuffix")) != null) {
            this.registry.setUninstallName(this.registry.getUninstallName() + " " + uninstallSuffix);
        }
        if (uninstallerPack == null) {
            this.registerUninstallKey();
        }
        if ((info = this.registry.getLoggingInfo()) != null) {
            this.uninstallData.addAdditionalData("registryEntries", info);
        }
        this.registryModificationLog = info;
    }

    private void performPack(IXMLElement pack) throws InstallerException, NativeLibException {
        List<IXMLElement> regEntries;
        if (pack == null) {
            return;
        }
        String packCondition = pack.getAttribute("condition");
        if (packCondition != null) {
            logger.fine("Condition \"" + packCondition + "\" found for pack of registry entries");
            if (!this.rules.isConditionTrue(packCondition)) {
                logger.fine("Condition \"" + packCondition + "\" not true");
                return;
            }
        }
        if ((regEntries = pack.getChildren()) == null) {
            return;
        }
        for (IXMLElement regEntry : regEntries) {
            String type;
            String condition = regEntry.getAttribute("condition");
            if (condition != null) {
                logger.fine("Condition " + condition + " found for registry entry");
                if (!this.rules.isConditionTrue(condition)) {
                    logger.fine("Condition \"" + condition + "\" not true");
                    continue;
                }
            }
            if ((type = regEntry.getName()).equalsIgnoreCase(REG_KEY)) {
                this.performKeySetting(regEntry);
                continue;
            }
            if (type.equalsIgnoreCase(REG_VALUE)) {
                this.performValueSetting(regEntry);
                continue;
            }
            this.spec.parseError(regEntry, "Non-valid type of entry; only 'key' and 'value' are allowed.");
        }
    }

    private void performValueSetting(IXMLElement regEntry) throws InstallerException, NativeLibException {
        String name = this.spec.getRequiredAttribute(regEntry, REG_BASENAME);
        name = this.substituter.substitute(name);
        String keypath = this.spec.getRequiredAttribute(regEntry, REG_KEYPATH);
        keypath = this.substituter.substitute(keypath);
        String root = this.spec.getRequiredAttribute(regEntry, REG_ROOT);
        int rootId = this.resolveRoot(regEntry, root);
        this.registry.setRoot(rootId);
        String override = regEntry.getAttribute(REG_OVERRIDE, "true");
        if (!"true".equalsIgnoreCase(override) && this.registry.getValue(keypath, name, null) != null) {
            return;
        }
        this.registry.setLogPrevSetValueFlag("true".equalsIgnoreCase(regEntry.getAttribute(SAVE_PREVIOUS, "true")));
        String value = regEntry.getAttribute(REG_DWORD);
        if (value != null) {
            value = this.substituter.substitute(value);
            this.registry.setValue(keypath, name, Long.parseLong(value));
            return;
        }
        value = regEntry.getAttribute(REG_STRING);
        if (value != null) {
            value = this.substituter.substitute(value);
            this.registry.setValue(keypath, name, value);
            return;
        }
        List<IXMLElement> values = regEntry.getChildrenNamed(REG_MULTI);
        if (values != null && !values.isEmpty()) {
            Iterator<IXMLElement> multiIter = values.iterator();
            String[] multiString = new String[values.size()];
            int i = 0;
            while (multiIter.hasNext()) {
                IXMLElement element = multiIter.next();
                multiString[i] = this.spec.getRequiredAttribute(element, REG_DATA);
                multiString[i] = this.substituter.substitute(multiString[i]);
                ++i;
            }
            this.registry.setValue(keypath, name, multiString);
            return;
        }
        values = regEntry.getChildrenNamed(REG_BIN);
        if (values != null && !values.isEmpty()) {
            Iterator<IXMLElement> multiIter = values.iterator();
            StringBuilder buf = new StringBuilder();
            while (multiIter.hasNext()) {
                IXMLElement element = multiIter.next();
                String tmp = this.spec.getRequiredAttribute(element, REG_DATA);
                buf.append(tmp);
                if (tmp.endsWith(",") || !multiIter.hasNext()) continue;
                buf.append(",");
            }
            byte[] bytes = this.extractBytes(regEntry, this.substituter.substitute(buf.toString()));
            this.registry.setValue(keypath, name, bytes);
            return;
        }
        this.spec.parseError(regEntry, "No data found.");
    }

    private byte[] extractBytes(IXMLElement element, String byteString) throws InstallerException {
        StringTokenizer st = new StringTokenizer(byteString, ",");
        byte[] retval = new byte[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            byte value = 0;
            String token = st.nextToken().trim();
            try {
                int tval = Integer.parseInt(token, 16);
                if (tval < 0 || tval > 255) {
                    throw new InstallerException("Byte value out of range: " + tval);
                }
                if (tval > 127) {
                    tval -= 256;
                }
                value = (byte)tval;
            }
            catch (NumberFormatException nfe) {
                this.spec.parseError(element, "Bad entry for REG_BINARY; a byte should be written as 2 digit hexvaluefollowed by a ','.");
            }
            retval[i++] = value;
        }
        return retval;
    }

    private void performKeySetting(IXMLElement regEntry) throws InstallerException, NativeLibException {
        String path = this.spec.getRequiredAttribute(regEntry, REG_KEYPATH);
        path = this.substituter.substitute(path);
        String root = this.spec.getRequiredAttribute(regEntry, REG_ROOT);
        int rootId = this.resolveRoot(regEntry, root);
        this.registry.setRoot(rootId);
        if (!this.registry.keyExist(path)) {
            this.registry.createKey(path);
        }
    }

    private int resolveRoot(IXMLElement regEntry, String root) {
        String root1 = this.substituter.substitute(root);
        Integer tmp = RegistryHandler.ROOT_KEY_MAP.get(root1);
        if (tmp != null) {
            return tmp;
        }
        this.spec.parseError(regEntry, "Unknown value (" + root1 + ") for registry root.");
        return 0;
    }

    /*
     * Loose catch block
     */
    private void registerUninstallKey() throws NativeLibException {
        String uninstallName = this.registry.getUninstallName();
        if (uninstallName == null) {
            return;
        }
        InstallData installData = this.getInstallData();
        String keyName = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + uninstallName;
        String uninstallerPath = IoHelper.translatePath(installData.getInfo().getUninstallerPath(), installData.getVariables());
        String cmd = "\"" + installData.getVariable("JAVA_HOME") + "\\bin\\javaw.exe\" -jar \"" + uninstallerPath + "\\" + installData.getInfo().getUninstallerName() + "\"";
        String appVersion = installData.getVariable("APP_VER");
        String appUrl = installData.getVariable("APP_URL");
        try {
            this.registry.setRoot(-2147483646);
            this.registry.setValue(keyName, "DisplayName", uninstallName);
        }
        catch (NativeLibException exception) {
            logger.warning("Failed to register uninstaller in HKEY_LOCAL_MACHINE hive, trying HKEY_CURRENT_USER: " + exception.getMessage());
            this.registry.setRoot(-2147483647);
            this.registry.setValue(keyName, "DisplayName", uninstallName);
        }
        this.registry.setValue(keyName, "UninstallString", cmd);
        this.registry.setValue(keyName, "DisplayVersion", appVersion);
        if (appUrl != null && appUrl.length() > 0) {
            this.registry.setValue(keyName, "HelpLink", appUrl);
        }
        InputStream in = null;
        FileOutputStream out = null;
        try {
            in = this.resources.getInputStream(UNINSTALLER_ICON);
            String iconPath = installData.getVariable("INSTALL_PATH") + File.separator + "Uninstaller" + File.separator + "UninstallerIcon.ico";
            out = new FileOutputStream(iconPath);
            IoHelper.copyStream(in, out);
            this.registry.setValue(keyName, "DisplayIcon", iconPath);
        }
        catch (ResourceNotFoundException exception) {
            logger.info(exception.getMessage());
            FileUtils.close(in);
            FileUtils.close(out);
        }
        catch (IOException exception2) {
            throw new InstallerException(exception2);
            {
                catch (Throwable throwable) {
                    FileUtils.close(in);
                    FileUtils.close(out);
                    throw throwable;
                }
            }
        }
        FileUtils.close(in);
        FileUtils.close(out);
    }
}

