/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.handler;

import com.izforge.izpack.api.handler.AbstractPrompt;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.util.Console;

public class ConsolePrompt
extends AbstractPrompt {
    private final Console console;
    private final String okCancelPrompt;
    private final String yesNoPrompt;
    private final String yesNoCancelPrompt;
    private final String ok;
    private final String cancel;
    private final String yes;
    private final String no;

    public ConsolePrompt(Console console, Messages messages) {
        this.console = console;
        this.okCancelPrompt = messages.get("ConsolePrompt.okCancel", new Object[0]);
        this.yesNoPrompt = messages.get("ConsolePrompt.yesNo", new Object[0]);
        this.yesNoCancelPrompt = messages.get("ConsolePrompt.yesNoCancel", new Object[0]);
        this.ok = messages.get("ConsolePrompt.ok", new Object[0]);
        this.cancel = messages.get("ConsolePrompt.cancel", new Object[0]);
        this.yes = messages.get("ConsolePrompt.yes", new Object[0]);
        this.no = messages.get("ConsolePrompt.no", new Object[0]);
    }

    @Override
    public void message(Prompt.Type type, String title, String message) {
        this.console.println(message);
    }

    @Override
    public Prompt.Option confirm(Prompt.Type type, String title, String message, Prompt.Options options, Prompt.Option defaultOption) {
        Prompt.Option result;
        this.console.println(message);
        if (options == Prompt.Options.OK_CANCEL) {
            String defaultValue = defaultOption != null && defaultOption == Prompt.Option.OK ? this.ok : this.cancel;
            String selected = this.console.prompt(this.okCancelPrompt, new String[]{this.ok, this.cancel}, defaultValue);
            result = this.ok.equals(selected) ? Prompt.Option.OK : Prompt.Option.CANCEL;
        } else if (options == Prompt.Options.YES_NO_CANCEL) {
            String selected;
            String defaultValue = this.cancel;
            if (defaultOption != null) {
                if (defaultOption == Prompt.Option.YES) {
                    defaultValue = this.yes;
                } else if (defaultOption == Prompt.Option.NO) {
                    defaultValue = this.no;
                }
            }
            result = this.yes.equals(selected = this.console.prompt(this.yesNoCancelPrompt, new String[]{this.yes, this.no, this.cancel}, defaultValue)) ? Prompt.Option.YES : (this.no.equals(selected) ? Prompt.Option.NO : Prompt.Option.CANCEL);
        } else {
            String selected;
            String defaultValue = this.no;
            if (defaultOption != null && defaultOption == Prompt.Option.YES) {
                defaultValue = this.yes;
            }
            result = this.yes.equals(selected = this.console.prompt(this.yesNoPrompt, new String[]{this.yes, this.no}, defaultValue)) ? Prompt.Option.YES : Prompt.Option.NO;
        }
        return result;
    }
}

