/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.data;

import com.izforge.izpack.api.data.DynamicVariable;
import com.izforge.izpack.api.data.Value;
import com.izforge.izpack.api.data.ValueFilter;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.core.variable.PlainValue;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DynamicVariableImpl
implements DynamicVariable {
    private static final long serialVersionUID = -7985397187206803090L;
    private static final transient Logger logger = Logger.getLogger(DynamicVariableImpl.class.getName());
    private String name;
    private Value value;
    private String conditionid;
    private List<ValueFilter> filters;
    private boolean checkonce = false;
    private boolean ignorefailure = true;
    private transient String currentValue;
    private transient boolean checked = false;

    public DynamicVariableImpl() {
    }

    public DynamicVariableImpl(String name, String value) {
        this.setName(name);
        this.setValue(new PlainValue(value));
    }

    @Override
    public void addFilter(ValueFilter filter) {
        if (this.filters == null) {
            this.filters = new LinkedList<ValueFilter>();
        }
        this.filters.add(filter);
    }

    @Override
    public List<ValueFilter> getFilters() {
        return this.filters;
    }

    @Override
    public void validate() throws Exception {
        if (this.name == null) {
            throw new Exception("No dynamic variable name defined");
        }
        if (this.value == null) {
            throw new Exception("No dynamic variable value defined for variable " + this.name);
        }
        this.value.validate();
        if (this.filters != null) {
            for (ValueFilter filter : this.filters) {
                filter.validate();
            }
        }
    }

    private String filterValue(String value, VariableSubstitutor ... substitutors) throws Exception {
        String newValue = value;
        if (value != null && this.filters != null) {
            logger.fine("Dynamic variable before filtering: " + this.name + "=" + newValue);
            for (ValueFilter filter : this.filters) {
                newValue = filter.filter(newValue, substitutors);
                logger.fine("Dynamic variable after applying filter " + filter.getClass().getSimpleName() + ": " + this.name + "=" + newValue);
            }
        }
        return newValue;
    }

    @Override
    public String evaluate(VariableSubstitutor ... substitutors) throws Exception {
        String newValue = this.currentValue;
        if (this.value == null) {
            return null;
        }
        if (this.checkonce && this.currentValue != null) {
            return this.filterValue(this.currentValue, substitutors);
        }
        try {
            newValue = this.value.resolve(substitutors);
            if (this.checkonce) {
                this.currentValue = newValue;
            }
            newValue = this.filterValue(newValue, substitutors);
        }
        catch (Exception e) {
            if (!this.ignorefailure) {
                throw e;
            }
            logger.log(Level.FINE, "Error evaluating dynamic variable '" + this.getName() + "': " + e, e);
            return null;
        }
        return newValue;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (name != null) {
            this.name = name;
        }
    }

    @Override
    public Value getValue() {
        return this.value;
    }

    @Override
    public void setValue(Value value) {
        if (value != null) {
            this.value = value;
        }
    }

    @Override
    public String getConditionid() {
        return this.conditionid;
    }

    @Override
    public void setConditionid(String conditionid) {
        if (conditionid != null) {
            this.conditionid = conditionid;
        }
    }

    @Override
    public boolean isCheckonce() {
        return this.checkonce;
    }

    @Override
    public void setCheckonce(boolean checkonce) {
        this.checkonce = checkonce;
    }

    public boolean isIgnoreFailure() {
        return this.ignorefailure;
    }

    @Override
    public void setIgnoreFailure(boolean ignore) {
        this.ignorefailure = ignore;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DynamicVariable)) {
            return false;
        }
        DynamicVariable compareObj = (DynamicVariable)obj;
        return this.name.equals(compareObj.getName()) && (this.conditionid == null || this.conditionid.equals(compareObj.getConditionid()));
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.conditionid.hashCode();
    }

    @Override
    public boolean isChecked() {
        return this.checked;
    }

    @Override
    public void setChecked() {
        this.checked = true;
    }
}

